<?php

App::uses('AppController', 'Controller');

class BundlesController extends AppController
{
    public $layout = 'member';

    public function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('view');
    }

    public function isAuthorized($user = null)
    {
        return parent::isAuthorized($user);
    }

    public function view($username = null, $id = null)
    {
        $this->layout = 'frontend';

        App::uses('User', 'Model');
        $userObj = new User();
        $user = $userObj->findByUsername($username);

        if (!$user) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user', $user);

        if (!$id) {
            throw new NotFoundException(__('404 Not Found'));
        }

        $bundle = $this->Bundle->find('first', array(
            'conditions' => array('Bundle.user_id' => $user['User']['id'], 'Bundle.user_bundle_id' => $id),
        ));

        if (!$bundle) {
            throw new NotFoundException(__('404 Not Found'));
        }

        if ($bundle['Bundle']['private'] == 1) {
            throw new NotFoundException(__('404 Not Found.'));
        }


        $plan_id = $user['User']['plan_id'];
        if ($bundle['Bundle']['user_id'] == 1) {
            $plan_id = Configure::read('Option.default_public_plan');
        }

        $user_plan = $this->Bundle->User->Plan->findById($plan_id);
        if (!$user_plan) {
            throw new NotFoundException(__('404 Not Found'));
        }
        $this->set('user_plan', $user_plan);


        $this->set('bundle', $bundle);
        $this->set('website_title', $bundle['Bundle']['name']);
        $this->set('website_description', $bundle['Bundle']['description']);

        $this->Bundle->updateAll(array('Bundle.views' => 'Bundle.views+1'), array('Bundle.id' => $bundle['Bundle']['id']));

        $links = $this->Bundle->Link->findAllByBundleId($bundle['Bundle']['id']);
        $this->set('links', $links);
    }

    public function admin_index()
    {
        $this->layout = 'admin';

        $conditions = array();
        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->data['Filter'])) {
            $filter_url['controller'] = $this->request->params['controller'];
            $filter_url['action'] = $this->request->params['action'];
            // We need to overwrite the page every time we change the parameters
            $filter_url['page'] = 1;

            // for each filter we will add a GET parameter for the generated url
            foreach ($this->data['Filter'] as $name => $value) {
                if ($value) {
                    // You might want to sanitize the $value here
                    // or even do a urlencode to be sure
                    $filter_url[$name] = urlencode($value);
                }
            }
            // now that we have generated an url with GET parameters,
            // we'll redirect to that page
            return $this->redirect($filter_url);
        } else {
            // Inspect all the named parameters to apply the filters
            foreach ($this->params['named'] as $param_name => $value) {
                // Don't apply the default named parameters used for pagination
                if (!in_array($param_name, array('page', 'sort', 'direction', 'limit'))) {
                    // You may use a switch here to make special filters
                    // like "between dates", "greater than", etc

                    $search_params = array();

                    if (in_array($param_name, $search_params)) {
                        $conditions[] = array(
                            array('Link.' . $param_name . ' LIKE' => '%' . $value . '%')
                        );
                    } elseif ($param_name == 'name_desc') {
                        $conditions['OR'] = array(
                            array('Bundle.name LIKE' => '%' . $value . '%'),
                            array('Bundle.description LIKE' => '%' . $value . '%')
                        );
                    } else {
                        $conditions['Bundle.' . $param_name] = $value;
                    }
                    $this->request->data['Filter'][$param_name] = $value;
                }
            }
        }

        $this->paginate = array(
            'joins' => array(
                array('table' => 'users',
                    'alias' => 'User',
                    'type' => 'LEFT',
                    'conditions' => array(
                        'Bundle.user_id = User.id',
                    )
                )
            ),
            'conditions' => $conditions,
            'fields' => array('Bundle.id', 'Bundle.user_id', 'Bundle.user_bundle_id', 'Bundle.name', 'Bundle.private', 'Bundle.views', 'Bundle.created', 'Bundle.updated', 'User.id', 'User.username'),
            'limit' => 10,
            'order' => array(
                'Bundle.created' => 'desc'
            )
        );
        $bundles = $this->paginate('Bundle');

        $this->set('bundles', $bundles);

        $this->set('website_title', 'All Bundles');
    }

    public function members_index()
    {
        $conditions = array();
        //Transform POST into GET
        if (($this->request->is('post') || $this->request->is('put')) && isset($this->data['Filter'])) {
            $filter_url['controller'] = $this->request->params['controller'];
            $filter_url['action'] = $this->request->params['action'];
            // We need to overwrite the page every time we change the parameters
            $filter_url['page'] = 1;

            // for each filter we will add a GET parameter for the generated url
            foreach ($this->data['Filter'] as $name => $value) {
                if ($value) {
                    // You might want to sanitize the $value here
                    // or even do a urlencode to be sure
                    $filter_url[$name] = urlencode($value);
                }
            }
            // now that we have generated an url with GET parameters,
            // we'll redirect to that page
            return $this->redirect($filter_url);
        } else {
            // Inspect all the named parameters to apply the filters
            foreach ($this->params['named'] as $param_name => $value) {
                // Don't apply the default named parameters used for pagination
                if (!in_array($param_name, array('page', 'sort', 'direction', 'limit'))) {
                    // You may use a switch here to make special filters
                    // like "between dates", "greater than", etc

                    $search_params = array();

                    if (in_array($param_name, $search_params)) {
                        $conditions[] = array(
                            array('Link.' . $param_name . ' LIKE' => '%' . $value . '%')
                        );
                    } elseif ($param_name == 'name_desc') {
                        $conditions['OR'] = array(
                            array('Bundle.name LIKE' => '%' . $value . '%'),
                            array('Bundle.description LIKE' => '%' . $value . '%')
                        );
                    } else {
                        $conditions['Bundle.' . $param_name] = $value;
                    }
                    $this->request->data['Filter'][$param_name] = $value;
                }
            }
        }

        $conditions[] = array('Bundle.user_id' => $this->Auth->user('id'));


        $this->paginate = array(
            'conditions' => $conditions,
            //'fields' => array('Bundle.id', 'Bundle.user_bundle_id', 'Bundle.name', 'Bundle.private', 'Bundle.created', 'Bundle.updated'),
            'limit' => 10,
            'order' => array(
                'Bundle.created' => 'desc'
            )
        );
        $bundles = $this->paginate('Bundle');

        $this->set('bundles', $bundles);
        $this->set('website_title', 'All Bundles');
    }

    public function members_add()
    {
        $this->set('website_title', 'Add Bundle');
        if ($this->request->is('post')) {
            $this->request->data['Bundle']['user_id'] = $this->Auth->user('id');
            $this->request->data['Bundle']['user_bundle_id'] = $this->Bundle->getNewBundleId();

            $this->Bundle->create();
            if ($this->Bundle->save($this->request->data)) {
                $this->loadModel('User');
                $this->User->updateAll(
                    array(
                    'User.last_bundle_id' => $this->Bundle->getNewBundleId()
                    ),
                    array('User.id' => $this->Auth->user('id'))
                );

                $this->Flash->set('The bundle has been saved.', array(
                    'element' => 'success'
                ));
                $this->redirect(array('action' => 'index'));
            } else {
                $this->Flash->set('The bundle could not be saved. Please, try again.', array(
                    'element' => 'error'
                ));
            }
        }
    }

    public function members_edit($id = null)
    {
        $this->set('website_title', 'Edit Bundle');

        if (!$id) {
            throw new NotFoundException(__('Invalid bundle'));
        }

        $bundle = $this->Bundle->find('first', array(
            'conditions' => array('Bundle.user_id' => $this->Auth->user('id'), 'Bundle.id' => $id),
        ));
        if (!$bundle) {
            throw new NotFoundException(__('Invalid bundle.'));
        }

        if ($this->request->is(array('post', 'put'))) {
            $this->Bundle->id = $id;
            if ($this->Bundle->save($this->request->data)) {
                $this->Flash->set('Your bundle has been updated.', array(
                    'element' => 'success'
                ));
                $this->redirect(array('action' => 'index'));
            } else {
                $this->Flash->set('Unable to update your bundle.', array(
                    'element' => 'error'
                ));
            }
        }

        if (!$this->request->data) {
            $this->request->data = $bundle;
        }
    }

    public function admin_edit($id = null)
    {
        $this->set('website_title', 'Edit Bundle');

        if (!$id) {
            throw new NotFoundException(__('Invalid bundle'));
        }

        $bundle = $this->Bundle->find('first', array(
            'conditions' => array('Bundle.user_id' => $this->Auth->user('id'), 'Bundle.id' => $id),
        ));
        if (!$bundle) {
            throw new NotFoundException(__('Invalid bundle.'));
        }

        if ($this->request->is(array('post', 'put'))) {
            $this->Bundle->id = $id;

            if ($this->Bundle->save($this->request->data)) {
                $this->Flash->set('Your bundle has been updated.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Flash->set('Unable to update your bundle.', array(
                    'element' => 'error'
                ));
            }
        }

        if (!$this->request->data) {
            $this->request->data = $bundle;
        }
    }

    public function admin_delete($id = null)
    {
        if (!$id) {
            throw new NotFoundException(__('Invalid URL.'));
        }

        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }

        $bundle = $this->Bundle->find('first', array(
            'conditions' => array(
                //'Bundle.user_id' => $this->Auth->user('id'),
                'Bundle.id' => $id
            ),
        ));
        if (!$bundle) {
            throw new NotFoundException(__('Invalid URL.'));
        }

        $this->Bundle->id = $id;

        /**
         * Used to delete associated recoreds
         */
        $this->Bundle->userId = $bundle['Bundle']['user_id'];

        if ($this->Bundle->delete()) {
            $this->Flash->set('Bundle deleted.', array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'index'));
        } else {
            $this->Flash->set('Bundle was not deleted.', array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }
    }

    public function members_delete($id = null)
    {
        if (!$id) {
            throw new NotFoundException(__('Invalid URL.'));
        }

        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }

        $bundle = $this->Bundle->find('first', array(
            'conditions' => array('Bundle.user_id' => $this->Auth->user('id'),
                'Bundle.id' => $id),
        ));
        if (!$bundle) {
            throw new NotFoundException(__('Invalid URL.'));
        }

        $this->Bundle->id = $id;

        if (!$this->Bundle->isOwnedBy($this->Bundle->id, $this->Auth->user('id'))) {
            throw new NotFoundException(__('Invalid Bundle'));
        }

        /**
         * Used to delete associated recoreds
         */
        $this->Bundle->userId = $bundle['Bundle']['user_id'];

        if ($this->Bundle->delete()) {
            $this->Flash->set('Bundle deleted.', array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'index'));
        } else {
            $this->Flash->set('Bundle was not deleted.', array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }
    }
}
